<?php $__env->startSection('content'); ?>
<?php
$policys = getContent('policy_pages.element', false, null, true);
?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/parsleyjs/src/parsley.css">

<section class="account-section d-flex align-items-center justify-content-center">
    <div class="account-card text-center">

        <!-- Logo -->
        <div class="mb-4">
            <a href="<?php echo e(route('home')); ?>" class="account-logo">
                <img src="<?php echo e(siteLogo()); ?>" alt="logo" class="login-logo">
            </a>
        </div>

        <!-- Register Form -->
       <form class="login-form verify-gcaptcha" action="<?php echo e(route('user.register')); ?>" method="POST" id="registerForm" data-parsley-validate>
            <?php echo csrf_field(); ?>
            <h3 class="mb-4 text-white"><?php echo app('translator')->get('Create Account'); ?></h3>

            <div class="row">
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label"><?php echo app('translator')->get('First Name'); ?></label>
                    <input type="text" name="firstname" value="<?php echo e(old('firstname')); ?>" required class="form-control" data-parsley-required-message="First name is required">
                </div>
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label"><?php echo app('translator')->get('Last Name'); ?></label>
                    <input type="text" name="lastname" value="<?php echo e(old('lastname')); ?>" required class="form-control" data-parsley-required-message="Last name is required">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label"><?php echo app('translator')->get('E-Mail Address'); ?></label>
                    <input type="email" name="email" value="<?php echo e(old('email')); ?>" required class="form-control checkUser" data-parsley-type="email" data-parsley-required-message="Valid email is required">
                </div>
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label"><?php echo app('translator')->get('Mobile'); ?></label>
                    <input type="number" name="mobile" value="<?php echo e(old('mobile')); ?>" required class="form-control checkUser" data-parsley-type="digits" data-parsley-minlength="10" data-parsley-required-message="Mobile number is required">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label"><?php echo app('translator')->get('Password'); ?></label>
                    <input type="password" name="password" required minlength="6" class="form-control <?php if(gs('secure_password')): ?> secure-password <?php endif; ?>"
                        data-parsley-required-message="Password is required"
                        data-parsley-minlength="6"
                        data-parsley-minlength-message="Password must be at least 6 characters">
                </div>
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label"><?php echo app('translator')->get('Confirm Password'); ?></label>
                    <input type="password" name="password_confirmation" required class="form-control"
                        data-parsley-equalto="[name=password]" 
                        data-parsley-required-message="Please confirm your password"
                        data-parsley-equalto-message="Passwords do not match">
                </div>
            </div>

            <?php if(session()->get('reference')): ?>
            <div class="form-group mb-3 text-start">
                <label class="form-label"><?php echo app('translator')->get('Reference By'); ?></label>
                <input type="text" name="referBy" value="<?php echo e(session()->get('reference')); ?>" readonly class="form-control">
            </div>
            <?php else: ?>
            <div class="form-group mb-3 text-start">
                <label class="form-label"><?php echo app('translator')->get('Reference By'); ?>(Optional)</label>
                <input type="text" name="referBy" value="<?php echo e(old('referBy')); ?>" class="form-control">
            </div>
            <?php endif; ?>

            <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>

            <?php if(gs('agree')): ?>
            <div class="form-group text-start mt-3">
                <input id="check" name="agree" type="checkbox" class="form-check" required data-parsley-required-message="You must agree before signing up">
                <label for="check" class="form-label">
                    <?php echo app('translator')->get('I agree with'); ?>
                    <?php $__currentLoopData = $policys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a class="" href="<?php echo e(route('policy.pages', [slug($policy->data_values->title), $policy->id])); ?>"><?php echo e(__($policy->data_values->title)); ?></a><?php if(!$loop->last): ?>, <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </label>
            </div>
            <?php endif; ?>

            <button type="submit" class="btn btn-primary w-100 mt-3"><?php echo app('translator')->get('Sign Up'); ?></button>

            <p class="mt-3 text-white"><?php echo app('translator')->get('Already have an account?'); ?>
                <a href="<?php echo e(route('user.login')); ?>" class=""><?php echo app('translator')->get('Sign In'); ?></a>
            </p>
        </form>

        <!-- Footer -->
        <div class="mt-4">
            <p class="m-0 text-white">&copy; <?php echo app('translator')->get('All Rights Reserved By'); ?>
                <a href="<?php echo e(route('home')); ?>" class=""><?php echo e(__(gs('site_name'))); ?></a>
            </p>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
<style>
    .account-section {
        min-height: 100vh;
        background: #111;
        padding: 20px;
    }

    .account-card {
        background: #000;
        padding: 50px 40px;
        border-radius: 12px;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.5);
        max-width: 520px;
        width: 100%;
    }

    .login-logo {
        height: 70px;
    }

    .form-label {
        font-weight: 500;
        color: #fff;
        margin-bottom: 6px;
    }

    .login-form .form-control {
        border-radius: 8px;
        padding: 12px 14px;
        border: 1px solid #444;
        background: #222;
        color: #fff;
    }

    .login-form .form-control:focus {
        border-color: #f99f0b;
        background: #1a1a1a;
        color: #fff;
        box-shadow: none;
    }

    .btn-primary {
        background: #f99f0b;
        border: none;
        padding: 12px;
        border-radius: 8px;
        font-weight: 600;
        color: #fff;
    }

    .btn-primary:hover {
        background: #e58900;
    }

    .text-theme {
        color: #f99f0b !important;
    }

    .text-theme:hover {
        text-decoration: underline;
    }

    /* ✅ Make checkbox smaller */
    .form-check {
        width: auto;
        display: inline-block;
        vertical-align: middle;
    }

    .form-check input[type="checkbox"] {
        width: 16px;
        height: 16px;
        cursor: pointer;
        margin-right: 6px;
    }

</style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
<!-- jQuery (latest version from Google CDN) -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

<!-- ✅ Include Parsley.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>
<script>
    // Init parsley
    $('#registerForm').parsley();
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp8.4\www\matrix\core\resources\views/templates/basic/user/auth/register.blade.php ENDPATH**/ ?>