<header class="site-header">
    <div class="container">
        <div class="header-inner d-flex align-items-center justify-content-between">

            <!-- Logo -->
            <div class="header-logo">
                <a href="<?php echo e(route('home')); ?>">
                    <img src="<?php echo e(siteLogo()); ?>" alt="logo">
                </a>
            </div>

            <!-- Navigation -->
            <nav class="header-nav d-none d-lg-block">
                <ul class="nav-list d-flex align-items-center">
    <li>
        <a href="<?php echo e(route('home')); ?>" class="<?php echo e(request()->routeIs('home') ? 'active' : ''); ?>"><?php echo app('translator')->get('Home'); ?></a>
    </li>

    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li>
            <a href="<?php echo e(route('pages', [$data->slug])); ?>" 
               class="<?php echo e(request()->is('pages/'.$data->slug) ? 'active' : ''); ?>">
               <?php echo e(__($data->name)); ?>

            </a>
        </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <li><a href="<?php echo e(route('plan')); ?>" class="<?php echo e(request()->routeIs('plan') ? 'active' : ''); ?>"><?php echo app('translator')->get('Plan'); ?></a></li>
    <li><a href="<?php echo e(route('blog')); ?>" class="<?php echo e(request()->routeIs('blog') ? 'active' : ''); ?>"><?php echo app('translator')->get('Blog'); ?></a></li>
    <li><a href="<?php echo e(route('contact')); ?>" class="<?php echo e(request()->routeIs('contact') ? 'active' : ''); ?>"><?php echo app('translator')->get('Contact'); ?></a></li>
</ul>

            </nav>

            <!-- Right Side -->
            <div class="header-right d-flex align-items-center gap-3">
                <!-- Language Switcher -->
                <?php if(gs('multi_language')): ?>
                    <?php
                        $language = App\Models\Language::all();
                        $selectLanguage = App\Models\Language::where('code', session('lang'))->first();
                    ?>
                    <div class="dropdown language-switcher">
                        <button class="btn dropdown-toggle d-flex align-items-center gap-2" data-bs-toggle="dropdown">
                            <img src="<?php echo e(getImage(getFilePath('language') . '/' . $selectLanguage->image)); ?>" class="lang-flag" alt="flag">
                            <span><?php echo e(__($selectLanguage->name)); ?></span>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a class="dropdown-item langSel d-flex align-items-center gap-2" data-code="<?php echo e($item->code); ?>">
                                        <img src="<?php echo e(getImage(getFilePath('language') . '/' . $item->image)); ?>" class="lang-flag" alt="flag">
                                        <?php echo e(__($item->name)); ?>

                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <!-- Auth Buttons -->
                <?php if(auth()->guard()->guest()): ?>
                    <a href="<?php echo e(route('user.login')); ?>" class="btn btn-primary"><?php echo app('translator')->get('Sign In'); ?></a>
                <?php endif; ?>

                <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('user.home')); ?>" class="btn btn-primary"><?php echo app('translator')->get('Dashboard'); ?></a>
                <?php endif; ?>

                <!-- Mobile Menu Toggle -->
                <button class="header-toggle d-lg-none">
                    <i class="las la-bars"></i>
                </button>
            </div>
        </div>
    </div>

    <!-- Mobile Nav -->
    <div class="mobile-nav d-lg-none">
        <ul class="mobile-nav-list">
    <li><a href="<?php echo e(route('home')); ?>" class="<?php echo e(request()->routeIs('home') ? 'active' : ''); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li><a href="<?php echo e(route('pages', [$data->slug])); ?>" 
               class="<?php echo e(request()->is('pages/'.$data->slug) ? 'active' : ''); ?>">
               <?php echo e(__($data->name)); ?>

            </a>
        </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <li><a href="<?php echo e(route('plan')); ?>" class="<?php echo e(request()->routeIs('plan') ? 'active' : ''); ?>"><?php echo app('translator')->get('Plan'); ?></a></li>
    <li><a href="<?php echo e(route('blog')); ?>" class="<?php echo e(request()->routeIs('blog') ? 'active' : ''); ?>"><?php echo app('translator')->get('Blog'); ?></a></li>
    <li><a href="<?php echo e(route('contact')); ?>" class="<?php echo e(request()->routeIs('contact') ? 'active' : ''); ?>"><?php echo app('translator')->get('Contact'); ?></a></li>
</ul>

    </div>
</header>


<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            const $mainlangList = $(".langList");
            const $langBtn = $(".language-content");
            const $langListItem = $mainlangList.children();

            $langListItem.each(function() {
                const $innerItem = $(this);
                const $languageText = $innerItem.find(".language_text");
                const $languageFlag = $innerItem.find(".language_flag");

                $innerItem.on("click", function(e) {
                    $langBtn.find(".language_text_select").text($languageText.text());
                    $langBtn.find(".language_flag").html($languageFlag.html());
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
<script>
    document.querySelector('.header-toggle').addEventListener('click', function() {
        document.querySelector('.mobile-nav').classList.toggle('d-block');
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        /* Active Link Styling */
.nav-list li a.active,
.mobile-nav-list li a.active {
    background: #f99f0b !important;
    color: #fff !important;
    border-radius: 6px;
    padding: 10px 16px;
}

      /* Header Base */
.site-header {
    background: #000;
    color: #fff;
    
    position: sticky;
    top: 0;
    z-index: 1000;
}

/* Logo */
.header-logo img {
    height: 100px;
}

/* Navigation */
.nav-list {
    list-style: none;
    gap: 24px;
    margin: 0;
    padding: 0;
}
.nav-list li a {
    color: #fff;
    font-weight: 500;
    transition: color .2s ease;
}
.nav-list li a:hover {
    padding:10px;
    background:#e58900;
    color: #fff;
}

/* Language Switcher */
.language-switcher .btn {
    background: transparent;
    color: #fff;
    border: none;
    font-size: 14px;
}
.lang-flag {
    height: 20px;
    width: 20px;
    border-radius: 50%;
    object-fit: cover;
}
.dropdown-menu {
    background: #124656;
    border-radius: 8px;
    border: 1px solid rgba(255,255,255,0.1);
}
.dropdown-item {
    color: #fff;
}
.dropdown-item:hover {
    background: #f99f0b;
    color: #fff;
}

/* Buttons */
.btn-primary {
    background: #f99f0b;
    border: none;
    padding: 6px 16px;
    border-radius: 6px;
    font-weight: 500;
    color: #fff;
}
.btn-primary:hover {
    background: #e58900;
}

/* Mobile Nav */
.header-toggle {
    background: transparent;
    border: none;
    font-size: 26px;
    color: #fff;
}
.mobile-nav {
    background: #000;
    display: none;
    padding: 10px 0;
}
.mobile-nav-list {
    list-style: none;
    margin: 0;
    padding: 0;
}
.mobile-nav-list li {
    border-bottom: 1px solid rgba(255,255,255,0.1);
}
.mobile-nav-list li a {
    
    display: block;
    padding: 12px 20px;
    color: #fff;
}
.mobile-nav-list li a:hover {
    background: #f99f0b;
}

    </style>
<?php $__env->stopPush(); ?>
<?php /**PATH E:\xampp8.4\www\matrix\core\resources\views/templates/basic/partials/header.blade.php ENDPATH**/ ?>