<?php $__env->startSection('content'); ?>
    <?php
        $kycInfo = getContent('kyc_info.content', true);
    ?>
    <div class="dashboard-section padding-top padding-bottom">
        <div class="container">

            <div class="notice"></div>

            <?php
                $kyc = getContent('kyc.content', true);
            ?>
            <?php if(auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason): ?>
                <div class="alert alert--danger" role="alert">
                    <div class="alert__icon"><i class="fas fa-file-signature"></i></div>
                    <p class="alert__message">
                        <span class="fw-bold"><?php echo app('translator')->get('KYC Documents Rejected'); ?></span><br>
                        <small><i><?php echo e(__(@$kyc->data_values->reject)); ?>

                                <a class="link-color" data-bs-toggle="modal" data-bs-target="#kycRejectionReason" href="javascript::void(0)"><?php echo app('translator')->get('Click here'); ?></a> <?php echo app('translator')->get('to show the reason'); ?>.

                                <a class="link-color" href="<?php echo e(route('user.kyc.form')); ?>"><?php echo app('translator')->get('Click Here'); ?></a>
                                <?php echo app('translator')->get('to Re-submit Documents'); ?>. <br>
                                <a class="link-color" href="<?php echo e(route('user.kyc.data')); ?>"><?php echo app('translator')->get('See KYC Data'); ?></a>
                            </i></small>
                    </p>
                </div>
            <?php elseif($user->kv == Status::KYC_UNVERIFIED): ?>
                <div class="alert alert--info" role="alert">
                    <div class="alert__icon"><i class="fas fa-file-signature"></i></div>
                    <p class="alert__message">
                        <span class="fw-bold"><?php echo app('translator')->get('KYC Verification Required'); ?></span><br>
                        <small><i><?php echo e(__(@$kyc->data_values->required)); ?>

                                <a class="link-color" href="<?php echo e(route('user.kyc.form')); ?>"><?php echo app('translator')->get('Click here'); ?></a>
                                <?php echo app('translator')->get('to submit KYC information'); ?>.</i></small>
                    </p>
                </div>
            <?php elseif($user->kv == Status::KYC_PENDING): ?>
                <div class="alert alert--warning" role="alert">
                    <div class="alert__icon"><i class="fas fa-user-check"></i></div>
                    <p class="alert__message">
                        <span class="fw-bold"><?php echo app('translator')->get('KYC Verification Pending'); ?></span><br>
                        <small><i><?php echo e(__(@$kyc->data_values->pending)); ?> <a class="link-color" href="<?php echo e(route('user.kyc.data')); ?>"><?php echo app('translator')->get('Click here'); ?></a> <?php echo app('translator')->get('to see your submitted information'); ?></i></small>
                    </p>
                </div>
            <?php endif; ?>

            <?php if(auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason): ?>
                <div class="modal fade custom--modal" id="kycRejectionReason">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title"><?php echo app('translator')->get('KYC Document Rejection Reason'); ?></h5>
                                <button class="close text-white" data-bs-dismiss="modal" type="button" aria-label="Close">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                            <div class="modal-body">
                                <p><?php echo e(auth()->user()->kyc_rejection_reason); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="row justify-content-center mb-30-none">
                <div class="col-md-12">
                    <div class="input-group form-group">
                        <input class="form-control referralURL referral-input" name="key" type="text" value="<?php echo e(route('user.register')); ?>?reference=<?php echo e($user->username); ?>" readonly>
                        <button class="input-group-text copytext bg--base border--base text-white" id="copyBoard" type="button"> <i class="fa fa-copy"></i> </button>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4">
                    <div class="dashboard-item">
                        <div class="dashboard-thumb">
                            <i class="fas fa-money-bill"></i>
                        </div>
                        <div class="dashboard-content">
                            <h5 class="title"><?php echo app('translator')->get('Current Balance'); ?></h5>
                            <h4 class="amount"><?php echo e(showAmount($user->balance)); ?></h4>
                        </div>
                    </div>
                </div>

               

                <div class="col-md-6 col-lg-4">
                    <div class="dashboard-item">
                        <div class="dashboard-thumb">
                            <i class="far fa-credit-card"></i>
                        </div>
                        <div class="dashboard-content">
                            <h5 class="title"><?php echo app('translator')->get('Withdraw'); ?></h5>
                            <h4 class="amount"><?php echo e(showAmount($withdraw)); ?></h4>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4">
                    <div class="dashboard-item">
                        <div class="dashboard-thumb">
                            <i class="fas fa-money-check-alt"></i>
                        </div>
                        <div class="dashboard-content">
                            <h5 class="title"><?php echo app('translator')->get('Total Transactions'); ?></h5>
                            <h4 class="amount"><?php echo e($transaction); ?></h4>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4">
                    <div class="dashboard-item">
                        <div class="dashboard-thumb">
                            <i class="fas fa-money-bill"></i>
                        </div>
                        <div class="dashboard-content">
                            <h5 class="title"><?php echo app('translator')->get('Total Commission'); ?></h5>
                            <h4 class="amount"><?php echo e(showAmount($commission)); ?></h4>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4">
                    <div class="dashboard-item">
                        <div class="dashboard-thumb">
                            <i class="fas fa-coins"></i>
                        </div>
                        <div class="dashboard-content">
                            <h5 class="title"><?php echo app('translator')->get('My Plan'); ?></h5>
                            <h4 class="amount"><?php echo e(__($user->plan->name ?? 'N/A')); ?></h4>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12 mt-5">
                    <div class="card custom--card primary-bg">
                        <div class="card-header">
                            <h5 class="card-title"><?php echo app('translator')->get('Latest Trasactions'); ?></h5>
                        </div>
                        <div class="card-body p-0">
                            <table class="deposite-table">
                                <thead class="custom--table">
                                    <tr>
                                        <th><?php echo app('translator')->get('Date'); ?></th>
                                        <th><?php echo app('translator')->get('TRX'); ?></th>
                                        <th><?php echo app('translator')->get('Amount'); ?></th>
                                        <th><?php echo app('translator')->get('Charge'); ?></th>
                                        <th><?php echo app('translator')->get('Post Balance'); ?></th>
                                        <th><?php echo app('translator')->get('Detail'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td>
                                                <?php echo e(showDateTime($trx->created_at)); ?>

                                                <br>
                                                <?php echo e(diffforhumans($trx->created_at)); ?>

                                            </td>
                                            <td>
                                                <?php echo e($trx->trx); ?>

                                            </td>
                                            <td class="budget">
                                                <strong
                                                        <?php if($trx->trx_type == '+'): ?> class="text--success" <?php else: ?> class="text--danger" <?php endif; ?>>
                                                    <?php echo e($trx->trx_type == '+' ? '+' : '-'); ?> <?php echo e(getAmount($trx->amount)); ?>

                                                    <?php echo e(__(gs('cur_text'))); ?>

                                                </strong>
                                            </td>
                                            <td class="budget">
                                                <?php echo e(__(__(gs('cur_sym')))); ?>

                                                <?php echo e(getAmount($trx->charge)); ?>

                                            </td>
                                            <td><?php echo e(getAmount($trx->post_balance)); ?>

                                                <?php echo e(__(gs('cur_text'))); ?>

                                            </td>
                                            <td><?php echo e(__($trx->details)); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('#copyBoard').click(function() {
                var copyText = document.getElementsByClassName("referralURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                /*For mobile devices*/
                document.execCommand("copy");
                copyText.blur();
                this.classList.add('copied');
                setTimeout(() => this.classList.remove('copied'), 1500);
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .copied::after {
            background-color: #<?php echo e(gs('base_color')); ?>;
        }
        .amount{color:#f99f0b !important;}
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp8.4\www\matrix\core\resources\views/templates/basic/user/dashboard.blade.php ENDPATH**/ ?>