<?php $__env->startSection('content'); ?>
    <div class="transaction-section padding-top padding-bottom">
        <div class="container">
            <div class="row justify-content-center">

                <?php if(!request()->routeIs('user.recharge.log')): ?>
                    <div class="col-md-12">
                        <div class="show-filter mb-3 text-end">
                            <button type="button" class="btn btn--base showFilterBtn btn-sm"><i class="las la-filter"></i>
                                <?php echo app('translator')->get('Filter'); ?></button>
                        </div>
                        <div class="card responsive-filter-card mb-4 primary-bg">
                            <div class="card-body">
                                <form>
                                    <div class="d-flex flex-wrap gap-4">
                                        <div class="flex-grow-1 form-group">
                                            <label><?php echo app('translator')->get('Transaction Number'); ?></label>
                                            <input type="text" name="search" value="<?php echo e(request()->search); ?>"
                                                class="form-control form--control">
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="form-group">
                                                <label><?php echo app('translator')->get('Type'); ?></label>
                                                <div class="select-item">
                                                    <select name="trx_type" class="select-bar select2"
                                                        data-minimum-results-for-search="-1">
                                                        <option value=""><?php echo app('translator')->get('All'); ?></option>
                                                        <option value="+" <?php if(request()->trx_type == '+'): echo 'selected'; endif; ?>>
                                                            <?php echo app('translator')->get('Plus'); ?>
                                                        </option>
                                                        <option value="-" <?php if(request()->trx_type == '-'): echo 'selected'; endif; ?>>
                                                            <?php echo app('translator')->get('Minus'); ?>
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="form-group">
                                                <label><?php echo app('translator')->get('Remark'); ?></label>
                                                <select class="select-bar select2" name="remark"
                                                    data-minimum-results-for-search="-1">
                                                    <option value=""><?php echo app('translator')->get('Any'); ?></option>
                                                    <?php $__currentLoopData = $remarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $remark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($remark->remark); ?>" <?php if(request()->remark == $remark->remark): echo 'selected'; endif; ?>>
                                                            <?php echo e(__(keyToTitle($remark->remark))); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1 align-self-end">
                                            <div class="form-group">
                                                <button class="btn btn--base w-100"><i class="las la-filter"></i>
                                                    <?php echo app('translator')->get('Filter'); ?></button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="primary-bg item-rounded">
                <table class="deposite-table">
                    <thead class="custom--table">
                        <tr>
                            <th><?php echo app('translator')->get('Date'); ?></th>
                            <th><?php echo app('translator')->get('TRX'); ?></th>
                            <th><?php echo app('translator')->get('Amount'); ?></th>
                            <th><?php echo app('translator')->get('Charge'); ?></th>
                            <th><?php echo app('translator')->get('Post Balance'); ?></th>
                            <th><?php echo app('translator')->get('Detail'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <?php echo e(showDateTime($trx->created_at)); ?>

                                    <br>
                                    <?php echo e(diffforhumans($trx->created_at)); ?>

                                </td>

                                <td>
                                    <?php echo e($trx->trx); ?>

                                </td>

                                <td>
                                    <strong
                                        <?php if($trx->trx_type == '+'): ?> class="text--success" <?php else: ?> class="text--danger" <?php endif; ?>>
                                        <?php echo e($trx->trx_type == '+' ? '+' : '-'); ?> <?php echo e(getAmount($trx->amount)); ?>

                                        <?php echo e(__(gs('cur_text'))); ?></strong>
                                </td>

                                <td>
                                    <?php echo e(getAmount($trx->charge)); ?> <?php echo e(__(gs('cur_text'))); ?>

                                </td>
                                <td>
                                    <?php echo e(getAmount($trx->post_balance)); ?> <?php echo e(__(gs('cur_text'))); ?></td>
                                <td class="text-end">
                                    <?php echo e(__($trx->details)); ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                <div class="paginate-wrapper">
                    <?php if($transactions->hasPages()): ?>
                        <?php echo e(paginateLinks($transactions)); ?>

                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp8.4\www\matrix\core\resources\views/templates/basic/user/transactions.blade.php ENDPATH**/ ?>