@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="transaction-section padding-top padding-bottom">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="primary-bg item-rounded">
                        <div class="p-3">
                            <div class="support-header d-flex justify-content-end justify-content-md-between align-items-center flex-wrap gap-2">
                                <form class="support-search w-100" action="{{ route('user.erecharge') }}" method="POST">
                                    @csrf
                                    <div class="input-group contact-from-group">
                                        <input name="pin" type="text" placeholder="Enter Pin" required="">
                                        <button type="submit">@lang('Recharge Now')</button>
                                    </div>
                                </form>
                                <button class="btn btn--base" data-bs-toggle="modal" data-bs-target="#generatePin"><i class="fa fa-fw fa-paper-plane"></i> @lang('Create Pin')</button>
                            </div>
                        </div>
                        <table class="deposite-table">
                            <thead>
                                <tr>
                                    <th>@lang('User')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Pin')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Details')</th>
                                    <th>@lang('Date')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($pins as $pin)
                                    <tr>
                                        <td>
                                            @if ($pin->user_id)
                                                <span>{{ __($pin->user->username) }}</span>
                                            @else
                                                <span>@lang('N/A')</span>
                                            @endif
                                        </td>
                                        <td>{{ getAmount($pin->amount) }}
                                            {{ __(gs('cur_text')) }}</td>
                                        <td>{{ $pin->pin }}</td>
                                        <td>
                                            @if ($pin->status == 1)
                                                <span class="badge badge--success">@lang('Used')</span>
                                                <br>
                                                {{ diffforhumans($pin->updated_at) }}
                                            @elseif($pin->status == 0)
                                                <span class="badge badge--danger">@lang('Unused')</span>
                                            @endif
                                        </td>
                                        <td>{{ __($pin->details) }}</td>
                                        <td>
                                            {{ showDateTime($pin->created_at) }}
                                            <br>
                                            {{ diffforhumans($pin->created_at) }}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        {{ paginateLinks($pins) }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade custom--modal" id="generatePin" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">@lang('Created Pin')</h5>
                    <button class="close text-white" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <form action="{{ route('user.pin.generate') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <div class="input-group mb-3">
                                <input class="form-control" name="amount" type="number" value="{{ old('amount') }}" aria-describedby="basic-addon2" placeholder="@lang('Enter Amount')" step="any" required="">
                                <div class="input-group-text">
                                    {{ __(gs('cur_text')) }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--danger" data-bs-dismiss="modal" type="button">@lang('Close')</button>
                        <button class="btn btn--primary bg--base" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
