@extends($activeTemplate . 'layouts.master')
@section('content')
    @php
        $kycInfo = getContent('kyc_info.content', true);
    @endphp
    <div class="dashboard-section padding-top padding-bottom">
        <div class="container">

            <div class="notice"></div>

            @php
                $kyc = getContent('kyc.content', true);
            @endphp
            @if (auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason)
                <div class="alert alert--danger" role="alert">
                    <div class="alert__icon"><i class="fas fa-file-signature"></i></div>
                    <p class="alert__message">
                        <span class="fw-bold">@lang('KYC Documents Rejected')</span><br>
                        <small><i>{{ __(@$kyc->data_values->reject) }}
                                <a class="link-color" data-bs-toggle="modal" data-bs-target="#kycRejectionReason" href="javascript::void(0)">@lang('Click here')</a> @lang('to show the reason').

                                <a class="link-color" href="{{ route('user.kyc.form') }}">@lang('Click Here')</a>
                                @lang('to Re-submit Documents'). <br>
                                <a class="link-color" href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a>
                            </i></small>
                    </p>
                </div>
            @elseif ($user->kv == Status::KYC_UNVERIFIED)
                <div class="alert alert--info" role="alert">
                    <div class="alert__icon"><i class="fas fa-file-signature"></i></div>
                    <p class="alert__message">
                        <span class="fw-bold">@lang('KYC Verification Required')</span><br>
                        <small><i>{{ __(@$kyc->data_values->required) }}
                                <a class="link-color" href="{{ route('user.kyc.form') }}">@lang('Click here')</a>
                                @lang('to submit KYC information').</i></small>
                    </p>
                </div>
            @elseif($user->kv == Status::KYC_PENDING)
                <div class="alert alert--warning" role="alert">
                    <div class="alert__icon"><i class="fas fa-user-check"></i></div>
                    <p class="alert__message">
                        <span class="fw-bold">@lang('KYC Verification Pending')</span><br>
                        <small><i>{{ __(@$kyc->data_values->pending) }} <a class="link-color" href="{{ route('user.kyc.data') }}">@lang('Click here')</a> @lang('to see your submitted information')</i></small>
                    </p>
                </div>
            @endif

            @if (auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason)
                <div class="modal fade custom--modal" id="kycRejectionReason">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">@lang('KYC Document Rejection Reason')</h5>
                                <button class="close text-white" data-bs-dismiss="modal" type="button" aria-label="Close">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                            <div class="modal-body">
                                <p>{{ auth()->user()->kyc_rejection_reason }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            <div class="row justify-content-center mb-30-none">
                <div class="col-md-12">
                    <div class="input-group form-group">
                        <input class="form-control referralURL referral-input" name="key" type="text" value="{{ route('user.register') }}?reference={{ $user->username }}" readonly>
                        <button class="input-group-text copytext bg--base border--base text-white" id="copyBoard" type="button"> <i class="fa fa-copy"></i> </button>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4">
                    <div class="dashboard-item">
                        <div class="dashboard-thumb">
                            <i class="fas fa-money-bill"></i>
                        </div>
                        <div class="dashboard-content">
                            <h5 class="title">@lang('Current Balance')</h5>
                            <h4 class="amount">{{ showAmount($user->balance) }}</h4>
                        </div>
                    </div>
                </div>

               

                <div class="col-md-6 col-lg-4">
                    <div class="dashboard-item">
                        <div class="dashboard-thumb">
                            <i class="far fa-credit-card"></i>
                        </div>
                        <div class="dashboard-content">
                            <h5 class="title">@lang('Withdraw')</h5>
                            <h4 class="amount">{{ showAmount($withdraw) }}</h4>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4">
                    <div class="dashboard-item">
                        <div class="dashboard-thumb">
                            <i class="fas fa-money-check-alt"></i>
                        </div>
                        <div class="dashboard-content">
                            <h5 class="title">@lang('Total Transactions')</h5>
                            <h4 class="amount">{{ $transaction }}</h4>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4">
                    <div class="dashboard-item">
                        <div class="dashboard-thumb">
                            <i class="fas fa-money-bill"></i>
                        </div>
                        <div class="dashboard-content">
                            <h5 class="title">@lang('Total Commission')</h5>
                            <h4 class="amount">{{ showAmount($commission) }}</h4>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4">
                    <div class="dashboard-item">
                        <div class="dashboard-thumb">
                            <i class="fas fa-coins"></i>
                        </div>
                        <div class="dashboard-content">
                            <h5 class="title">@lang('My Plan')</h5>
                            <h4 class="amount">{{ __($user->plan->name ?? 'N/A') }}</h4>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12 mt-5">
                    <div class="card custom--card primary-bg">
                        <div class="card-header">
                            <h5 class="card-title">@lang('Latest Trasactions')</h5>
                        </div>
                        <div class="card-body p-0">
                            <table class="deposite-table">
                                <thead class="custom--table">
                                    <tr>
                                        <th>@lang('Date')</th>
                                        <th>@lang('TRX')</th>
                                        <th>@lang('Amount')</th>
                                        <th>@lang('Charge')</th>
                                        <th>@lang('Post Balance')</th>
                                        <th>@lang('Detail')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($transactions as $trx)
                                        <tr>
                                            <td>
                                                {{ showDateTime($trx->created_at) }}
                                                <br>
                                                {{ diffforhumans($trx->created_at) }}
                                            </td>
                                            <td>
                                                {{ $trx->trx }}
                                            </td>
                                            <td class="budget">
                                                <strong
                                                        @if ($trx->trx_type == '+') class="text--success" @else class="text--danger" @endif>
                                                    {{ $trx->trx_type == '+' ? '+' : '-' }} {{ getAmount($trx->amount) }}
                                                    {{ __(gs('cur_text')) }}
                                                </strong>
                                            </td>
                                            <td class="budget">
                                                {{ __(__(gs('cur_sym'))) }}
                                                {{ getAmount($trx->charge) }}
                                            </td>
                                            <td>{{ getAmount($trx->post_balance) }}
                                                {{ __(gs('cur_text')) }}
                                            </td>
                                            <td>{{ __($trx->details) }}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="100%">{{ __($emptyMessage) }}</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";
            $('#copyBoard').click(function() {
                var copyText = document.getElementsByClassName("referralURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                /*For mobile devices*/
                document.execCommand("copy");
                copyText.blur();
                this.classList.add('copied');
                setTimeout(() => this.classList.remove('copied'), 1500);
            });
        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        .copied::after {
            background-color: #{{ gs('base_color') }};
        }
        .amount{color:#f99f0b !important;}
    </style>
@endpush
