@php
    $text = request()->routeIs('user.register') ? 'Register' : 'Login';
@endphp
@if (
    @gs('socialite_credentials')->linkedin->status ||
        @gs('socialite_credentials')->facebook->status == Status::ENABLE ||
        @gs('socialite_credentials')->google->status == Status::ENABLE)
    <div class="mt-3">
        <div class="social-auth">
            @if (@gs('socialite_credentials')->google->status == Status::ENABLE)
                <div class="continue-google">
                    <a href="{{ route('user.social.login', 'google') }}" class="social-login-btn">
                        <span class="google-icon">
                            <img src="{{ asset($activeTemplateTrue . 'images/google.svg') }}" alt="Google">
                        </span> @lang("$text with Google")
                    </a>
                </div>
            @endif

            @if (@gs('socialite_credentials')->facebook->status == Status::ENABLE)
                <div class="continue-facebook">
                    <a href="{{ route('user.social.login', 'facebook') }}" class="social-login-btn">
                        <span class="facebook-icon">
                            <img src="{{ asset($activeTemplateTrue . 'images/facebook.svg') }}" alt="Facebook">
                        </span> @lang("$text with Facebook")
                    </a>
                </div>
            @endif

            @if (@gs('socialite_credentials')->linkedin->status == Status::ENABLE)
                <div class="linkedin-facebook">
                    <a href="{{ route('user.social.login', 'linkedin') }}" class="social-login-btn">
                        <span class="linkedin-icon">
                            <img src="{{ asset($activeTemplateTrue . 'images/linkdin.svg') }}" alt="Linkedin">
                        </span> @lang("$text with Linkedin")
                    </a>
                </div>
            @endif
        </div>

        <div class="auth-devide">
            <span>@lang('OR')</span>
        </div>
    </div>
@endif

@push('style')
    <style>
        .social-login-btn {
            border: 1px solid rgba(255, 255, 255, .1);
            background-color: rgba(255, 255, 255, .06);
            padding: 7px 16px;
            border-radius: 4px;
            width: 100%;
            display: flex;
            align-items: center;
            gap: 12px;
            justify-content: center;
            color: #fff;
            font-size: 15px;
            transition: all linear 0.3s;
        }

        .social-login-btn:hover {
            background-color: rgba(255, 255, 255, .1);
            color: #fff;
        }

        .social-login-btn img {
            width: 20px;
        }

        .social-auth {
            display: flex;
            gap: 12px;
            flex-wrap: wrap
        }

        .auth-devide {
            text-align: center;
            margin-top: 24px;
            position: relative;
            z-index: 1;
        }

        .auth-devide::after {
            content: '';
            width: 100%;
            height: 1px;
            background: rgba(255, 255, 255, .1);
            position: absolute;
            top: 50%;
            left: 0;
            right: 0;
            z-index: -1;
        }

        .auth-devide span {
            padding-inline: 6px;
            background: #073b4b;
            color: #fff;
        }

        .linkedin-facebook,
        .continue-facebook,
        .continue-google {
            flex: auto 1 1;
        }
    </style>
@endpush
