@extends($activeTemplate.'layouts.frontend')
@section('content')
@php
$content = getContent('banner.content', true);
@endphp

@push('style')
<style>
    @media (min-width: 992px) {
    /* Banner Carousel fixed height */
    #bannerCarousel .carousel-item {
        height: 500px; /* 🔹 Set a fixed even height */
    }


    #bannerCarousel .carousel-item img {
        height: 100%;
        width: 100%;
        object-fit: cover; /* 🔹 Ensures image fills without distortion */
        border-radius: 12px;
    }
}
    /* Mobile view */
   .pill-title {
    display: inline-block;
    background: #000; /* change color as needed */
    color: #fff;
    padding: 10px 25px;
    border-radius: 50px;
    font-size: 1.2rem;
    font-weight: 600;
    text-transform: uppercase;
    box-shadow: 0 3px 8px rgba(0,0,0,0.15);
    letter-spacing: 1px;
}
</style>
@endpush

<div id="bannerCarousel" class="carousel slide" data-bs-ride="carousel">
    <div class="carousel-inner">

        @foreach($banners as $key => $banner)
            <div class="carousel-item {{ $key == 0 ? 'active' : '' }}">
                <img src="{{ getImage(getFilePath('banner') . '/' . $banner->image) }}" 
                     class="d-block w-100" 
                     alt="{{ $banner->title }}">
            </div>
        @endforeach

    </div>
</div>
<section class="about-section p-3">
    <div class="container">

        {{-- Real Estate Section --}}
        @if($contents->where('category', 'realestate')->count() > 0)
            <div class="row mb--60">
    <div class="col-12 text-center">
        <h3 class="section-title mb-5">
            <span class="pill-title">Real Estate</span>
        </h3>
    </div>
</div>

            @foreach($contents->where('category', 'realestate') as $content)
                <div class="row mb--50 align-items-center">
                    <div class="col-lg-6 mb-50">
                        <div class="about-content">
                            <div class="section-header margin-olpo left-style">
                                <h2 class="title">{{ $content->title }}</h2>
                            </div>
                            <p style="text-align:justify;">{!! $content->description !!}</p>
                        </div>
                    </div>
                    <div class="col-lg-6 mb-50">
                        <div class="image-wrapper even-img">
                            <img src="{{ getImage(getFilePath('content') . '/' . $content->image) }}" alt="{{ $content->title }}">
                        </div>
                    </div>
                </div>
            @endforeach
        @endif

        {{-- Agriculture Section --}}
        @if($contents->where('category', 'agri')->count() > 0)
            <div class="row mb--50 pt-5 pb-5">
                <div class="col-12">
                    <h3 class="section-title text-center mb-5"><span class="pill-title">Agriculture</span></h3>
                </div>
            </div>

            @foreach($contents->where('category', 'agri') as $content)
                <div class="row mb--50 align-items-center">
                    <div class="col-lg-6 mb-50">
                        <div class="about-content">
                            <div class="section-header margin-olpo left-style">
                                <h2 class="title">{{ $content->title }}</h2>
                            </div>
                            <p style="text-align:justify;">{!! $content->description !!}</p>
                        </div>
                    </div>
                    <div class="col-lg-6 mb-50">
                        <div class="image-wrapper even-img">
                            <img src="{{ getImage(getFilePath('content') . '/' . $content->image) }}" alt="{{ $content->title }}">
                        </div>
                    </div>
                </div>
            @endforeach
        @endif

    </div>
</section>

@push('style')
<style>
    /* Make all content images even size */
    .even-img {
        width: 100%;
        height: 350px; /* fixed height for desktop */
        overflow: hidden;
        border-radius: 10px;
    }
    .even-img img {
        width: 100%;
        height: 100%;
        object-fit: cover; /* crop instead of stretch */
        border-radius: 10px;
    }

    /* Mobile responsive - auto height */
    @media (max-width: 991px) {
        .even-img {
            height: 220px;
        }
    }
</style>
@endpush





@if($sections->secs != null)
    @foreach(json_decode($sections->secs) as $sec)
        @include($activeTemplate.'sections.'.$sec)
    @endforeach
@endif
@endsection
