@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th>@lang('User')</th>
                                    <th>@lang('Trx')</th>
                                    <th>@lang('Date')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Post Balance')</th>
                                    <th>@lang('Detail')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($commissions as $commission)
                                    <tr>
                                        <td>
                                            <span>{{ $commission->user->fullname }}</span>
                                            <br>
                                            <span class="small"> <a
                                                   href="{{ route('admin.users.detail', $commission->user_id) }}"><span>@</span>{{ $commission->user->username }}</a>
                                            </span>
                                        </td>

                                        <td>
                                            <strong>{{ $commission->trx }}</strong>
                                        </td>

                                        <td>
                                            {{ showDateTime($commission->created_at) }}<br>{{ diffForHumans($commission->created_at) }}
                                        </td>

                                        <td class="budget">
                                            <span class="text--success">
                                                + {{ showAmount($commission->amount) }}
                                            </span>
                                        </td>

                                        <td class="budget">
                                            {{ showAmount($commission->post_balance) }}
                                        </td>

                                        <td>{{ __($commission->details) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($commissions->hasPages())
                    <div class="card-footer py-4">
                        @php echo paginateLinks($commissions) @endphp
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <form class="search-group d-flex flex-wrap gap-2" method="GET">
        <div class="from-group">
            <div class="input-group flex-fill">
                <input class="form-control bg--white" name="search" type="search" value="{{ request()->search }}" placeholder="@lang('TRX / Username')">
                <button class="btn btn--primary" type="submit"><i class="la la-search"></i></button>
            </div>
        </div>

        <div class="form-group">
            <div class="input-group">
                <select class="form-control select2" name="remark" data-minimum-results-for-search="-1">
                    <option value="">@lang('Select One')</option>
                    @foreach ($remarks as $remark)
                        <option value="{{ $remark->remark }}" @selected(request()->remark == $remark->remark)>{{ __(keyToTitle($remark->remark)) }}</option>
                    @endforeach
                </select>
                <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
            </div>
        </div>
    </form>
@endpush

@push('style')
    <style>
        .select2-container .select2-selection--single,
        .select2-container--default .select2-selection--single .select2-selection__rendered,
        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 45px;
            line-height: 45px;
            min-width: 220px;
        }
    </style>
@endpush
