@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <form action="{{ route('admin.content.update', $content->id) }}" method="POST"
                      enctype="multipart/form-data">
                    @csrf

                    <div class="card-body">
                        <div class="payment-method-item">
                            <div class="gateway-body mb-4">
                                <!-- Image -->
                                <div class="gateway-thumb">
                                    <div class="thumb">
                                        <x-image-uploader 
                                            image="{{ $content->image }}" 
                                            class="w-100" 
                                            type="content" 
                                            :required=false />
                                    </div>
                                </div>

                                <!-- Form Inputs -->
                                <div class="gateway-content">
                                    <div class="row">
                                        <!-- Title -->
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label>@lang('Title')</label>
                                                <input type="text" class="form-control" 
                                                       name="title" 
                                                       value="{{ old('title', $content->title) }}" 
                                                       required />
                                            </div>
                                        </div>

                                        <!-- Category Dropdown -->
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label>@lang('Category')</label>
                                                <select name="category" class="form-control" required>
                                                    <option value="">@lang('Select Category')</option>
                                                    <option value="realestate" {{ old('category', $content->category) == 'realestate' ? 'selected' : '' }}>@lang('Real Estate')</option>
                                                    <option value="agri" {{ old('category', $content->category) == 'agri' ? 'selected' : '' }}>@lang('Agri')</option>
                                                </select>
                                            </div>
                                        </div>

                                        <!-- Description -->
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label>@lang('Description')</label>
                                                <textarea rows="10" 
                                                          class="form-control nicEdit" 
                                                          name="description">{{ old('description', $content->description) }}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>                           
                        </div>
                    </div>

                    <!-- Submit -->
                    <div class="card-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Update')</button>
                    </div>
                </form>
            </div><!-- card end -->
        </div>
    </div>

    <x-form-generator-modal />
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.content.index') }}" />
@endpush
