@extends('admin.layouts.app')
@section('panel')
<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>@lang('Title')</th>
                                <th>@lang('Image')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($plans as $plan)

                            <tr>
                                <td>
                                    {{ __($plan->title) }}
                                <td>
                                            <img
                                                src="{{ getImage(getFilePath('banner').'/'. $plan->image)}}" style="height:50px;width:100px"
                                                alt="@lang('image')"></div>

                                  
                                </td>


                                <td>

                                    <a href="{{ route('admin.banner.edit', $plan->id) }}"
                                        class="btn btn-sm btn-outline--primary editGatewayBtn">
                                        <i class="la la-pencil"></i>@lang('Edit')
                                    </a>


                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                            </tr>
                            @endforelse

                        </tbody>
                    </table>
                </div>
            </div>
            @if ($plans->hasPages())
            <div class="card-footer py-4">
                @php echo paginateLinks($plans) @endphp
            </div>
            @endif
        </div>
    </div>
</div>



<x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')

<a href="{{ route('admin.banner.create') }}" class="btn btn-sm btn-outline--primary addPlan"><i
        class="las la-plus"></i>@lang('Add Banner')</a>
@endpush

@push('script')
<script>
    "use strict";
    (function ($) {
        $('.matrixSetting').click(function () {
            $('#matrixSettingModal').modal('show');
        });
    })(jQuery);

</script>
@endpush
