<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Level;
use App\Traits\GlobalStatus;

class Plan extends Model
{
    use GlobalStatus;
    
    public function level()
    {
    	return $this->hasMany(Level::class);
    }

    public function sumLevelOfCommission($planId)
    {
    	return Level::where('plan_id', $planId)->where('level','<=',  gs('matrix_height'))->sum('amount');
    }

    public function totalLevel($planId)
    {
        return  Level::where('plan_id', $planId)->where('level','<=',  gs('matrix_height'))->get();
    }
    
}
