<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Lib\FormProcessor;
use App\Models\Content;
use App\Rules\FileTypeValidate;
use Illuminate\Http\Request;

class ContentController extends Controller
{
    public function index()
    {
        $pageTitle = 'Front Content';
        $content = Content::orderBy('id')->get();
        return view('admin.content.index', compact('pageTitle', 'content'));
    }

    public function create()
    {
        $pageTitle = 'New Content';
        return view('admin.content.create', compact('pageTitle'));
    }

    public function store(Request $request)
    {
        $validation = [
            'category' => 'required',
            'title' => 'required',
            'description' => 'required',
            'image' => ['required', 'image', new FileTypeValidate(['jpg', 'jpeg', 'png'])],
        ];


        $filename = null;
        if ($request->hasFile('image')) {
            try {
                $filename = fileUploader($request->image,getFilePath('content'));
            } catch (\Exception $exp) {
                $notify[] = ['errors', 'Image could not be uploaded'];
                return back()->withNotify($notify);
            }
        }

        $content = new Content();
        $content->category = $request->category;
        $content->image = $filename;
        $content->title = $request->title;
        $content->description = $request->description;
        
        $content->save();


        $notify[] = ['success', 'Content added successfully'];
        return to_route('admin.content.index')->withNotify($notify);
    }


    public function edit($id)
    {
        $pageTitle = 'Update Content';
        $content = Content::findOrFail($id);
        return view('admin.content.edit', compact('pageTitle', 'content'));
    }

    public function update(Request $request, $id)
    {
        $validation = [
             'category' => 'required',
            'title' => 'required',
            'description' => 'required',
            'image' => ['required', 'image', new FileTypeValidate(['jpg', 'jpeg', 'png'])],
        ];

        $content = Content::findOrFail($id);

        $filename = $content->image;
        if ($request->hasFile('image')) {
            try {
                $filename = fileUploader($request->image,getFilePath('content'),old:$filename);
            } catch (\Exception $exp) {
                $notify[] = ['errors', 'Image could not be uploaded'];
                return back()->withNotify($notify);
            }
        }

        $content->category = $request->category;
        $content->image = $filename;
        $content->title = $request->title;
        $content->description = $request->description;
        $content->save();

        $notify[] = ['success', 'Content updated successfully'];
        return back()->withNotify($notify);
    }



}
